/*
 * Copyright (c) 2006-2008 by Roland Riegel <feedback@roland-riegel.de>
 *
 * Later modifications (c) 2009 by Martin Howse <m@1010.co.uk>
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

/* modified for 8313 and RNG - no sleep, adc timing faster + RNG adds */

#include <stdio.h>
#include <avr/pgmspace.h>
#include <avr/sfr_defs.h>
#include <string.h>
#include <avr/interrupt.h>
#include <stdlib.h>
#include <avr/delay.h>
#include <avr/io.h>
#include "fat.h"
#include "fat_config.h"
#include "partition.h"
#include "sd_raw.h"
#include "sd_raw_config.h"
#include "uart.h"
#include <stdio.h>
#include "cywm.h"

#define RX_BUFF_LENGTH 32

#define UCSRC_SELECT 0
#define UCSZ0 UCSZ00
#define UCSZ1 UCSZ01

unsigned char rx_buffer[RX_BUFF_LENGTH+2];

//char * rx_buffer;

uint8_t rx_count,lenny,flag=0;

static uint8_t print_disk_info(const struct fat_fs_struct* fs);

#define sbi(var, mask)   ((var) |= (uint8_t)(1 << mask))
#define cbi(var, mask)   ((var) &= (uint8_t)~(1 << mask))

volatile int cont;

ISR(TIMER2_OVF_vect)
{
  cont++;
}

void setupgps(void){
  unsigned char j;
  static prog_uchar gps0[] PROGMEM ={0x10,0x7A,0x00,0x01,0x00,0x00,0x00,0x01,0x10,0x03}; // last but two: GGA and GSV also = 0x09 ... just GGA=0x01 //ends 0x01,0x03
  static prog_uchar gps1[] PROGMEM ={0x10,0xBC,0xFF,0x06,0x06,0x03,0x00,0x00,0x00,0x02,0x04,0x00,0x10,0x03};
  uart_init(9600);

  _delay_ms(8000);


  for (j=0;j<10;j++)
    {
      uart_putc(pgm_read_byte(gps0+j));
    }

  _delay_ms(2000);


  for (j=0;j<15;j++)
    {
      uart_putc(pgm_read_byte(gps1+j));
    }

  _delay_ms(1000);

  uart_init(4800);

  //  UCSR0C = (3 << UCSZ00);

  UCSR0B = (1 << RXEN0) | (1 << TXEN0);

  UCSR0C = UCSRC_SELECT | (1 << UCSZ1) | (1 << UCSZ0); // no parity!

  //    UCSR0C = UCSRC_SELECT | (1 << UCSZ1) | (1 << UCSZ0) | (1 << UPM01) | (1 << UPM00); // ??

}

void setupadc(void){

  cbi(ADMUX, REFS1);
  sbi(ADMUX, REFS0);

  // set a2d prescale factor to 128
  // 16 MHz / 128 = 125 KHz, inside the desired 50-200 KHz range.
  // XXX: this will not work properly for other clock speeds, and
  // this code should use F_CPU to determine the prescale factor.
  //	sbi(ADCSRA, ADPS2);
  sbi(ADCSRA, ADPS0); // now  for RNG speed up to /2 prescale

  // enable a2d conversions
  sbi(ADCSRA, ADEN);
	
}

int readadc(int pin)
{
  unsigned int low, high;

  // the low 4 bits of ADMUX select the ADC channel
  ADMUX = (ADMUX & (unsigned int) 0xf0) | (pin & (unsigned int) 0x0f);

  // without a delay, we seem to read from the wrong channel
  //			_delay_ms(10);

  // start the conversion
  sbi(ADCSRA, ADSC);

  // ADSC is cleared when the conversion finishes
  while (bit_is_set(ADCSRA, ADSC));

  // we have to read ADCL first; doing so locks both ADCL
  // and ADCH until ADCH is read.  reading ADCL second would
  // cause the results of each conversion to be discarded,
  // as ADCL and ADCH would be locked when it completed.
  low = ADCL;
  high = ADCH;

  // combine the two bytes
  return (high << 8) | low;
}


int main()
{
 
  int not,val,vall,valll;
  unsigned char index,c;

  unsigned char www,alt, accum, rr, y;
  unsigned int xx,x;
  c=accum=rr=xx=alt=0;


  char buffer[7];

  //  rx_buffer=malloc(RX_BUFF_LENGTH+3);


	    
  /* we will just use ordinary idle mode */
  //  set_sleep_mode(SLEEP_MODE_IDLE);

  //more sleep stuff

  TCCR2A=0;  
  TCCR2B=(0<<7)|(0<<6)|(0<<5)|(0<<4)|(0<<3)|(1<<2)|(1<<1)|(1<<0);
  TIMSK2=(0<<2)|(0<<1)|(1<<0);

  /* setup uart */
  //    uart_init(); //comm
  setupgps();
  setupadc();
  DDRC=0x02; DDRD= 0x62; // pd5/6 as outputs//TX also //flash pin PC1 of portC
  PORTC=0x00; PORTD=0x40; // pd5 as low and pd6 as high to switch both ad and cywm on
  DIDR0=0x01; /// ??? OUTT!!!
  //    DIDR1=0x03;
  sbi(ACSR,ACD); // disable comparator


  while(1){

    //      uart_puts_p(PSTR("RESTART\n"));

    /* setup sd card slot */
    if(!sd_raw_init())
      {
	//	  uart_puts_p(PSTR("MMC/SD initialization failed\n"));
	continue;
      }

    /* open first partition */
    struct partition_struct* partition = partition_open(sd_raw_read,
							sd_raw_read_interval,
							sd_raw_write,
							sd_raw_write_interval,
							0
							);

    if(!partition)
      {
	/* If the partition did not open, assume the storage device
	 * is a "superfloppy", i.e. has no MBR.
	 */
	partition = partition_open(sd_raw_read,
				   sd_raw_read_interval,
				   sd_raw_write,
				   sd_raw_write_interval,
				   -1
				   );
	if(!partition)
	  {
	    //	                      uart_puts_p(PSTR("opening partition failed\n"));

	    continue;          
	  }
      }


    /* open file system */
    struct fat_fs_struct* fs = fat_open(partition);
    if(!fs)
      {
#if DEBUG
	//            uart_puts_p(PSTR("opening filesystem failed\n"));
#endif
	continue;
      }

    /* open root directory */
    struct fat_dir_entry_struct directory;
    fat_get_dir_entry_of_path(fs, "/", &directory);

    struct fat_dir_struct* dd = fat_open_dir(fs, &directory);
    if(!dd)
      {
	//	  uart_puts_p(PSTR("opening root directory failed\n"));

	continue;
      }
        
    /* print some card information as a boot message */
    print_disk_info(fs);
    strcpy(buffer, "monk00");  buffer[6]='\0';
    // open new file
    while(1){
      not=0;
      struct fat_dir_entry_struct file_entry;

      for (buffer[4] = '0'; buffer[4] <= '9'; buffer[4]++) {
	for (buffer[5] = '0'; buffer[5] <= '9'; buffer[5]++) {

	  if(!fat_create_file(dd, buffer, &file_entry))
	    {
	      //		  uart_putc('>');
	    }
	  else {
	    not=1;
	    break;
	  }
	}
	if (not==1) break;
      }

      struct fat_file_struct* fd = fat_open_file(fs, &file_entry);
      if(!fd)
	{
	  continue;
	}

      int32_t offset=0;

      //		uart_puts_p(PSTR("writing now to\n"));
      //		uart_puts(buffer);

      //		init_cywm();

      while(1){
	/* here read RNG on pin7 adc2 */
	accum=0;
	for (y=0;y<200;y++){
	  for (x=0;x<166;x++){
	    www = readadc(2);
	    c=www&0x01;
	    if (c==0) xx++;
	  }
	  if ((xx&1)==1) x=0;
	  else x=1;
	  xx=0;
	  x= x ^ alt;
	  alt= alt ^ 1;
	  if (x==1)	accum++;
	}

	PORTD=0x40;
	_delay_ms(100);
	val=readadc(0);
	// read pin 8 adc1
		  
	c=0; lenny=0; index=0;
		  
			  		    while (c != '$')	          c = uart_getc(); // wait till we get a $

					    while (c != ',')	          c = uart_getc(); // wait till we get a ,
					    c=0;
					    while (c != ',')	          c = uart_getc(); // wait till we get a ,
					    c=0;
					    while (c != ',') {
					    c = uart_getc(); // wait till we get a ,
					    if (c!=',') rx_buffer[index]=c;
					    else rx_buffer[index]='0';
					    index++;
					    }
					    rx_buffer[index++]=',';
					    c=0;
					    while (c != ',')	          c = uart_getc(); // wait till we get a ,
					    c=0;
					    while (c != ',') {
					    c = uart_getc(); // wait till we get a ,
					    if (c!=',') rx_buffer[index]=c;
					    else break;
					    index++;
					    }
					    lenny=index;
					    /*		  while(index<16){
					    c = uart_getc();
					    rx_buffer[index]=c;
					    index++;
					    }
					    lenny=index;index=0;

	/* *** in order: ad8313 and entropy *** */


	lenny+=sprintf(rx_buffer+lenny,",%d, %d\n",val, accum);
	rx_buffer[lenny+1]=0;
	// test for any conns
	/*	    if (lenny>1) {
	// flash PC1
	PORTC=0x02;
	_delay_ms(100);
	PORTC=0x00;
	}*/


	if (lenny>15){ // was 15


	  if(!fat_seek_file(fd, &offset, FAT_SEEK_SET))
	    {
	      //			uart_puts_p(PSTR("error seeking on "));
	      //uart_putc('\n');
	      fat_close_file(fd);
	      _delay_ms(10 );
	      continue;
	    }
		  

	  //			uart_putc('>');

	  if(!fat_write_file(fd, (uint8_t*) rx_buffer , lenny))
	    {
	      //			uart_puts_p(PSTR("error writing on "));
	      //			uart_putc('\n');
	      fat_close_file(fd);
	      _delay_ms(10 );
	      continue;
	    }
	  else 
	    {
	      // flash PC1
	      PORTC=0x02;
	      _delay_ms(100);
	      PORTC=0x00;
	    }
	  offset+=lenny; lenny=0;

	}						   
	_delay_ms(10);
		  
      }
      fat_close_file(fd);
		
      //		while(1){}
    }
     
    fat_close(fs);

    /* close partition */
    partition_close(partition);
   

  }
   
    
  return 0;
}


uint8_t print_disk_info(const struct fat_fs_struct* fs)
{
  if(!fs)
    return 0;

  struct sd_raw_info disk_info;
  if(!sd_raw_get_info(&disk_info))
    return 0;

  //    uart_puts_p(PSTR("manuf:  0x")); uart_putc_hex(disk_info.manufacturer); uart_putc('\n');
  //    uart_puts_p(PSTR("oem:    ")); uart_puts((char*) disk_info.oem); uart_putc('\n');

  return 1;
}

#if FAT_DATETIME_SUPPORT
void get_datetime(uint16_t* year, uint8_t* month, uint8_t* day, uint8_t* hour, uint8_t* min, uint8_t* sec)
{
  *year = 2007;
  *month = 1;
  *day = 1;
  *hour = 0;
  *min = 0;
  *sec = 0;
}
#endif


